(**************************************************************************)
(* Copyright (c) 2010, Romain BARDOU                                      *)
(* All rights reserved.                                                   *)
(*                                                                        *)
(* Redistribution and  use in  source and binary  forms, with  or without *)
(* modification, are permitted provided that the following conditions are *)
(* met:                                                                   *)
(*                                                                        *)
(* * Redistributions  of  source code  must  retain  the above  copyright *)
(*   notice, this list of conditions and the following disclaimer.        *)
(* * Redistributions in  binary form  must reproduce the  above copyright *)
(*   notice, this list of conditions  and the following disclaimer in the *)
(*   documentation and/or other materials provided with the distribution. *)
(* * Neither the  name of Capucine nor  the names of its contributors may *)
(*   be used  to endorse or  promote products derived  from this software *)
(*   without specific prior written permission.                           *)
(*                                                                        *)
(* THIS SOFTWARE  IS PROVIDED BY  THE COPYRIGHT HOLDERS  AND CONTRIBUTORS *)
(* "AS  IS" AND  ANY EXPRESS  OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT *)
(* LIMITED TO, THE IMPLIED  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR *)
(* A PARTICULAR PURPOSE  ARE DISCLAIMED. IN NO EVENT  SHALL THE COPYRIGHT *)
(* OWNER OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, *)
(* SPECIAL,  EXEMPLARY,  OR  CONSEQUENTIAL  DAMAGES (INCLUDING,  BUT  NOT *)
(* LIMITED TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, *)
(* DATA, OR PROFITS; OR BUSINESS  INTERRUPTION) HOWEVER CAUSED AND ON ANY *)
(* THEORY OF  LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY,  OR TORT *)
(* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING  IN ANY WAY OUT OF THE USE *)
(* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.   *)
(**************************************************************************)

open Ocamlbuild_plugin

let native = false

let nativify x =
  if native then x ^ ".native" else x ^ ".byte"

let enter_build_dir () =
  Printf.printf
    "Ocamlbuild: Entering directory `%s'\n"
    (if Filename.is_relative !Options.build_dir then
       Filename.concat (Sys.getcwd ()) !Options.build_dir
     else
       !Options.build_dir)

let () = dispatch begin function
  | After_rules ->
      flag [ "ocamlyacc" ] (A "-v");

      rule "capucine: cap -> why"
        ~deps: [
          if native then nativify "main" else "main.byte";
          "%.cap";
        ]
        ~prod: "%.why"
        (fun env _ ->
           let cap = env "%.cap" and why = env "%.why" in
           Cmd (S [ A "ocamlrun"; A "-bt";
                    A (nativify "./main"); A "-o"; P why; P cap ]));

      rule "capucine: cap -> mlw"
        ~deps: [
          if native then nativify "main" else "main.byte";
          "%.cap";
        ]
        ~prod: "%.mlw"
        (fun env _ ->
           let cap = env "%.cap" and why = env "%.mlw" in
           Cmd (S [ A "ocamlrun"; A "-bt";
                    A (nativify "./main"); A "-why3"; A "-o"; P why; P cap ]));

      rule "gwhy: why -> gwhy"
        ~deps: [
          "lib/capucine.why";
          "%.why";
        ]
        ~prod: "%.gwhy"
        (fun env _ ->
(*           enter_build_dir ();*)
           let why = env "%.why" in
           Cmd (S [ A "gwhy-bin"; A "--split-user-conj"; (*A "--all-vc";*) P "lib/capucine.why"; P why ]));

(*
      rule "capucine.why -> capucine_why3.why"
        ~dep: "lib/capucine.why"
        ~prod: "lib/capucine_why3.why"
        (fun _ _ -> Cmd (S [ A "why"; A "-why3"; P "lib/capucine.why" ]));
*)

      rule "why3: mlw -> prouveurs"
        ~deps: [
          "lib/capucine_why3.why";
          "%.mlw";
        ]
        ~prod: "%.why3"
        (fun env _ ->
(*           enter_build_dir ();*)
           let mlw = env "%.mlw" in
           Cmd (S [ A "whyml3"; A "-a"; A "split_goal";
                    A "-I"; P "lib"; A "-P"; A "alt-ergo"; P mlw ]));

      rule "why3ide"
        ~deps: [
          "lib/capucine_why3.why";
          "%.mlw";
        ]
        ~prod: "%.why3ide"
        (fun env _ ->
(*           enter_build_dir ();*)
           let mlw = env "%.mlw" in
           Cmd (S [ A "why3ide"; A "-I"; P "lib"; P mlw ]));

      rule "coq: why -> coq"
        ~deps: [
          "lib/capucine.why";
          "%.why";
        ]
        ~prod: "%.coq"
        (fun env _ ->
(*           enter_build_dir ();*)
           let why = env "%.why" in
           Cmd (S [ A "why"; A "--coq"; (*A "--all-vc";*) P "lib/capucine.why"; P why ]));
  | _ -> ()
end
