(* Beware! Only edit allowed sections below    *)
(* This file is generated by Why3's Coq driver *)
Require Import ZArith.
Require Import Rbase.
Require Import ZOdiv.
Require Import Rbasic_fun.
Definition unit  := unit.

Parameter ignore: forall (a:Type), a  -> unit.
Implicit Arguments ignore.

Parameter arrow : forall (a:Type) (b:Type), Type.

Parameter ref : forall (a:Type), Type.

Parameter prefix_ex: forall (a:Type), (ref a)  -> a.
Implicit Arguments prefix_ex.

Parameter label : Type.

Parameter at1: forall (a:Type), a -> label  -> a.
Implicit Arguments at1.

Parameter old: forall (a:Type), a  -> a.
Implicit Arguments old.

Parameter exn : Type.

Definition lt_nat(x:Z) (y:Z): Prop := (0%Z <= y)%Z /\ (x <  y)%Z.

Axiom Abs_pos : forall (x:Z), (0%Z <= (Zabs x))%Z.

Axiom Div_mod : forall (x:Z) (y:Z), (~ (y = 0%Z)) ->
  (x = ((y * (ZOdiv x y))%Z + (ZOmod x y))%Z).

Axiom Div_bound : forall (x:Z) (y:Z), ((0%Z <= x)%Z /\ (0%Z <  y)%Z) ->
  ((0%Z <= (ZOdiv x y))%Z /\ ((ZOdiv x y) <= x)%Z).

Axiom Mod_bound : forall (x:Z) (y:Z), (~ (y = 0%Z)) ->
  (((-(Zabs y))%Z <  (ZOmod x y))%Z /\ ((ZOmod x y) <  (Zabs y))%Z).

Axiom Div_sign_pos : forall (x:Z) (y:Z), ((0%Z <= x)%Z /\ (0%Z <  y)%Z) ->
  (0%Z <= (ZOdiv x y))%Z.

Axiom Div_sign_neg : forall (x:Z) (y:Z), ((x <= 0%Z)%Z /\ (0%Z <  y)%Z) ->
  ((ZOdiv x y) <= 0%Z)%Z.

Axiom Mod_sign_pos : forall (x:Z) (y:Z), ((0%Z <= x)%Z /\ ~ (y = 0%Z)) ->
  (0%Z <= (ZOmod x y))%Z.

Axiom Mod_sign_neg : forall (x:Z) (y:Z), ((x <= 0%Z)%Z /\ ~ (y = 0%Z)) ->
  ((ZOmod x y) <= 0%Z)%Z.

Axiom Rounds_toward_zero : forall (x:Z) (y:Z), (~ (y = 0%Z)) ->
  ((Zabs ((ZOdiv x y) * y)%Z) <= (Zabs x))%Z.

Axiom Mod_1 : forall (x:Z), ((ZOmod x 1%Z) = 0%Z).

Axiom Div_1 : forall (x:Z), ((ZOdiv x 1%Z) = x).

Axiom Refl : forall (x:R), (x <= x)%R.

Axiom Trans : forall (x:R) (y:R) (z:R), (x <= y)%R -> ((y <= z)%R ->
  (x <= z)%R).

Axiom Antisymm : forall (x:R) (y:R), (x <= y)%R -> ((y <= x)%R -> (x = y)).

Axiom Total : forall (x:R) (y:R), (x <= y)%R \/ (y <= x)%R.

Axiom Abs_le : forall (x:R) (y:R), ((Rabs x) <= y)%R <-> (((-y)%R <= x)%R /\
  (x <= y)%R).

Axiom Abs_pos1 : forall (x:R), ((0)%R <= (Rabs x))%R.

Inductive mode  :=
  | nearestTiesToEven : mode 
  | toZero : mode 
  | up : mode 
  | down : mode 
  | nearTiesToAway : mode .

Parameter single : Type.

Axiom Zero : ((IZR 0%Z) = (0)%R).

Axiom One : ((IZR 1%Z) = (1)%R).

Axiom Add : forall (x:Z) (y:Z), ((IZR (x + y)%Z) = ((IZR x) + (IZR y))%R).

Axiom Sub : forall (x:Z) (y:Z), ((IZR (x - y)%Z) = ((IZR x) - (IZR y))%R).

Axiom Mul : forall (x:Z) (y:Z), ((IZR (x * y)%Z) = ((IZR x) * (IZR y))%R).

Axiom Neg : forall (x:Z) (y:Z), ((IZR (-x)%Z) = (-(IZR x))%R).

Parameter round: mode -> R  -> R.

Parameter round_logic: mode -> R  -> single.

Parameter value: single  -> R.

Parameter exact: single  -> R.

Parameter model: single  -> R.

Definition round_error(x:single): R := (Rabs ((value x) - (exact x))%R).

Definition total_error(x:single): R := (Rabs ((value x) - (model x))%R).

Definition no_overflow(m:mode) (x:R): Prop := ((Rabs (round m
  x)) <= (33554430 * 10141204801825835211973625643008)%R)%R.

Axiom Bounded_real_no_overflow : forall (m:mode) (x:R),
  ((Rabs x) <= (33554430 * 10141204801825835211973625643008)%R)%R ->
  (no_overflow m x).

Axiom Round_monotonic : forall (m:mode) (x:R) (y:R), (x <= y)%R -> ((round m
  x) <= (round m y))%R.

Axiom Exact_rounding_for_integers : forall (m:mode) (i:Z),
  (((-16777216%Z)%Z <= i)%Z /\ (i <= 16777216%Z)%Z) -> ((round m
  (IZR i)) = (IZR i)).

Axiom Round_down_le : forall (x:R), ((round (down ) x) <= x)%R.

Axiom Round_up_ge : forall (x:R), (x <= (round (up ) x))%R.

Axiom Round_down_neg : forall (x:R), ((round (down ) (-x)%R) = (-(round (up )
  x))%R).

Axiom Round_up_neg : forall (x:R), ((round (up ) (-x)%R) = (-(round (down )
  x))%R).

Parameter double : Type.

Parameter round1: mode -> R  -> R.

Parameter round_logic1: mode -> R  -> double.

Parameter value1: double  -> R.

Parameter exact1: double  -> R.

Parameter model1: double  -> R.

Definition round_error1(x:double): R := (Rabs ((value1 x) - (exact1 x))%R).

Definition total_error1(x:double): R := (Rabs ((value1 x) - (model1 x))%R).

Definition no_overflow1(m:mode) (x:R): Prop := ((Rabs (round1 m
  x)) <= (9007199254740991 * 19958403095347198116563727130368385660674512604354575415025472424372118918689640657849579654926357010893424468441924952439724379883935936607391717982848314203200056729510856765175377214443629871826533567445439239933308104551208703888888552684480441575071209068757560416423584952303440099278848)%R)%R.

Axiom Bounded_real_no_overflow1 : forall (m:mode) (x:R),
  ((Rabs x) <= (9007199254740991 * 19958403095347198116563727130368385660674512604354575415025472424372118918689640657849579654926357010893424468441924952439724379883935936607391717982848314203200056729510856765175377214443629871826533567445439239933308104551208703888888552684480441575071209068757560416423584952303440099278848)%R)%R ->
  (no_overflow1 m x).

Axiom Round_monotonic1 : forall (m:mode) (x:R) (y:R), (x <= y)%R ->
  ((round1 m x) <= (round1 m y))%R.

Axiom Exact_rounding_for_integers1 : forall (m:mode) (i:Z),
  (((-9007199254740992%Z)%Z <= i)%Z /\ (i <= 9007199254740992%Z)%Z) ->
  ((round1 m (IZR i)) = (IZR i)).

Axiom Round_down_le1 : forall (x:R), ((round1 (down ) x) <= x)%R.

Axiom Round_up_ge1 : forall (x:R), (x <= (round1 (up ) x))%R.

Axiom Round_down_neg1 : forall (x:R), ((round1 (down )
  (-x)%R) = (-(round1 (up ) x))%R).

Axiom Round_up_neg1 : forall (x:R), ((round1 (up )
  (-x)%R) = (-(round1 (down ) x))%R).

Parameter eq_unit: unit -> unit  -> Prop.

Parameter neq_unit: unit -> unit  -> Prop.

Parameter eq_bool: bool -> bool  -> Prop.

Parameter neq_bool: bool -> bool  -> Prop.

Parameter lt_int: Z -> Z  -> Prop.

Parameter le_int: Z -> Z  -> Prop.

Parameter gt_int: Z -> Z  -> Prop.

Parameter ge_int: Z -> Z  -> Prop.

Parameter eq_int: Z -> Z  -> Prop.

Parameter neq_int: Z -> Z  -> Prop.

Parameter add_int: Z -> Z  -> Z.

Parameter sub_int: Z -> Z  -> Z.

Parameter mul_int: Z -> Z  -> Z.

Parameter neg_int: Z  -> Z.

Definition zwf_zero(a:Z) (b:Z): Prop := (0%Z <= b)%Z /\ (a <  b)%Z.

Parameter couple : forall (a:Type) (b:Type), Type.

Parameter pair: forall (a1:Type) (a2:Type), a1 -> a2  -> (couple a1 a2).
Implicit Arguments pair.

Parameter fst: forall (a1:Type) (a2:Type), (couple a1 a2)  -> a1.
Implicit Arguments fst.

Parameter snd: forall (a2:Type) (a1:Type), (couple a2 a1)  -> a1.
Implicit Arguments snd.

Axiom Fst_pair : forall (a1:Type) (a2:Type), forall (a:a1), forall (b:a2),
  ((fst (pair a b)) = a).

Axiom Snd_pair : forall (a1:Type) (a2:Type), forall (a:a1), forall (b:a2),
  ((snd (pair a b)) = b).

Parameter either : forall (a:Type) (b:Type), Type.

Parameter left: forall (a1:Type) (a2:Type), a1  -> (either a1 a2).
Set Contextual Implicit.
Implicit Arguments left.
Unset Contextual Implicit.

Parameter right: forall (a2:Type) (a1:Type), a2  -> (either a1 a2).
Set Contextual Implicit.
Implicit Arguments right.
Unset Contextual Implicit.

Parameter eq: forall (a1:Type), a1 -> a1  -> bool.
Implicit Arguments eq.

Axiom Eq_is_equal : forall (a1:Type), forall (a:a1), forall (b:a1), ((eq a
  b) = true) <-> (a = b).

Parameter pointer : Type.

Parameter region : forall (a:Type), Type.

Parameter empty: forall (a1:Type),  (region a1).
Set Contextual Implicit.
Implicit Arguments empty.
Unset Contextual Implicit.

Parameter set: forall (a1:Type), (region a1) -> pointer -> a1  -> (region
  a1).
Implicit Arguments set.

Parameter get: forall (a1:Type), (region a1) -> pointer  -> a1.
Implicit Arguments get.

Axiom Get_set_eq : forall (a1:Type), forall (r:(region a1)),
  forall (p:pointer), forall (x:a1), ((get (set r p x) p) = x).

Axiom Get_set_neq : forall (a1:Type), forall (r:(region a1)),
  forall (p:pointer), forall (q:pointer), forall (x:a1), (~ (p = q)) ->
  ((get (set r p x) q) = (get r q)).

Parameter disjoint_union: forall (a1:Type), (region a1) -> (region a1)  ->
  (region a1).
Implicit Arguments disjoint_union.

Parameter in_region: forall (a1:Type), pointer -> (region a1)  -> Prop.
Implicit Arguments in_region.

Parameter extends: forall (a1:Type), (region a1) -> (region a1)  -> Prop.
Implicit Arguments extends.

Axiom Extends_reflexive : forall (a1:Type), forall (r:(region a1)),
  (extends r r).

Axiom Extends_conservative : forall (a1:Type), forall (r:(region a1)),
  forall (s:(region a1)), forall (p:pointer), (in_region p r) -> ((extends s
  r) -> ((get s p) = (get r p))).

Axiom Extends_set_not_in : forall (a1:Type), forall (r:(region a1)),
  forall (p:pointer), forall (x:a1), (~ (in_region p r)) -> (extends (set r p
  x) r).

Axiom Extends_set_eq : forall (a1:Type), forall (r:(region a1)),
  forall (p:pointer), forall (x:a1), ((get r p) = x) -> (extends (set r p x)
  r).

Parameter dirunion: forall (a1:Type), (region a1) -> (region a1)  -> (region
  a1).
Implicit Arguments dirunion.

Axiom In_dirunion : forall (a1:Type), forall (r:(region a1)),
  forall (s:(region a1)), forall (p:pointer), (in_region p (dirunion r
  s)) <-> ((in_region p r) \/ (in_region p s)).

Axiom Get_dirunion_left : forall (a1:Type), forall (r:(region a1)),
  forall (s:(region a1)), forall (p:pointer), (in_region p r) ->
  ((get (dirunion r s) p) = (get r p)).

Axiom Get_dirunion_right : forall (a1:Type), forall (r:(region a1)),
  forall (s:(region a1)), forall (p:pointer), (~ (in_region p r)) ->
  ((get (dirunion r s) p) = (get s p)).

Parameter usarray : forall (alpha:Type), Type.

Parameter store: forall (alpha0:Type) (a:Type), (usarray alpha0) -> Z -> a
   -> (usarray alpha0).
Implicit Arguments store.

Parameter select: forall (alpha1:Type), (usarray alpha1) -> Z  -> alpha1.
Implicit Arguments select.

Axiom Select_eq : forall (alpha2:Type), forall (a0:(usarray alpha2)),
  forall (i:Z), forall (v:alpha2), ((select (store a0 i v) i) = v).

Axiom Select_neq : forall (alpha3:Type), forall (a1:(usarray alpha3)),
  forall (i0:Z), forall (j:Z), forall (v0:alpha3), (~ (i0 = j)) ->
  ((select (store a1 i0 v0) j) = (select a1 j)).

Definition array_inv (alpha4:Type)(a2:(Z* (usarray alpha4))%type): Prop :=
  (0%Z <= match a2 with
  | (x, _) => x
  end)%Z.
Implicit Arguments array_inv.

Definition interval(a6:Z) (x:Z) (b:Z): Prop := (a6 <= x)%Z /\ (x <  b)%Z.

Definition sparse_inv (alpha8:Type)(rval_g:(region (Z* (usarray
  alpha8))%type)) (ridx_g:(region (Z* (usarray Z))%type)) (rback_g:(region
  (Z* (usarray Z))%type)) (x0:(pointer* pointer* pointer* Z* alpha8*
  Z)%type): Prop :=
  (((((0%Z <= match x0 with
  | (_, _, _, x, _, _) => x
  end)%Z /\
  (match x0 with
  | (_, _, _, x, _, _) => x
  end <= match x0 with
  | (_, _, _, _, _, x) => x
  end)%Z) /\ (match (get rval_g
  match x0 with
  | (x, _, _, _, _, _) => x
  end) with
  | (x, _) => x
  end = match x0 with
  | (_, _, _, _, _, x) => x
  end)) /\ (match (get ridx_g
  match x0 with
  | (_, x, _, _, _, _) => x
  end) with
  | (x, _) => x
  end = match x0 with
  | (_, _, _, _, _, x) => x
  end)) /\ (match (get rback_g
  match x0 with
  | (_, _, x, _, _, _) => x
  end) with
  | (x, _) => x
  end = match x0 with
  | (_, _, _, _, _, x) => x
  end)) /\ forall (i3:Z), (interval 0%Z i3
  match x0 with
  | (_, _, _, x, _, _) => x
  end) -> ((interval 0%Z (select match (get rback_g
  match x0 with
  | (_, _, x, _, _, _) => x
  end) with
  | (_, x) => x
  end i3) match x0 with
  | (_, _, _, _, _, x) => x
  end) /\ ((select match (get ridx_g
  match x0 with
  | (_, x, _, _, _, _) => x
  end) with
  | (_, x) => x
  end (select match (get rback_g
  match x0 with
  | (_, _, x, _, _, _) => x
  end) with
  | (_, x) => x
  end i3)) = i3)).
Implicit Arguments sparse_inv.

Definition is_elt (alpha9:Type)(r_g2:(region (pointer* pointer* pointer* Z*
  alpha9* Z)%type)) (r_rback_g:(region (Z* (usarray Z))%type))
  (r_ridx_g:(region (Z* (usarray Z))%type)) (r_rval_g:(region (Z* (usarray
  alpha9))%type)) (a7:pointer) (i4:Z): Prop :=
  ((0%Z <= (select match (get r_ridx_g match (get r_g2
  a7) with
  | (_, x, _, _, _, _) => x
  end) with
  | (_, x) => x
  end i4))%Z /\ ((select match (get r_ridx_g match (get r_g2
  a7) with
  | (_, x, _, _, _, _) => x
  end) with
  | (_, x) => x
  end i4) <  match (get r_g2 a7) with
  | (_, _, _, x, _, _) => x
  end)%Z) /\ ((select match (get r_rback_g match (get r_g2
  a7) with
  | (_, _, x, _, _, _) => x
  end) with
  | (_, x) => x
  end (select match (get r_ridx_g match (get r_g2
  a7) with
  | (_, x, _, _, _, _) => x
  end) with
  | (_, x) => x
  end i4)) = i4).
Implicit Arguments is_elt.

Axiom Is_elt_footprint : forall (alpha9:Type), forall (i4:Z),
  forall (a7:pointer), forall (r_rval_g:(region (Z* (usarray alpha9))%type)),
  forall (r_ridx_g:(region (Z* (usarray Z))%type)), forall (r_rback_g:(region
  (Z* (usarray Z))%type)), forall (r_g2:(region (pointer* pointer* pointer*
  Z* alpha9* Z)%type)), forall (r_rval_g_x:(region (Z* (usarray
  alpha9))%type)), forall (r_ridx_g_x:(region (Z* (usarray Z))%type)),
  forall (r_rback_g_x:(region (Z* (usarray Z))%type)), forall (r_g_x:(region
  (pointer* pointer* pointer* Z* alpha9* Z)%type)), (extends r_rval_g_x
  r_rval_g) -> ((extends r_ridx_g_x r_ridx_g) -> ((extends r_rback_g_x
  r_rback_g) -> ((extends r_g_x r_g2) -> ((is_elt r_g_x r_rback_g_x
  r_ridx_g_x r_rval_g_x a7 i4) <-> (is_elt r_g2 r_rback_g r_ridx_g r_rval_g
  a7 i4))))).

Parameter model2: forall (alpha10:Type), (region (pointer* pointer* pointer*
  Z* alpha10* Z)%type) -> (region (Z* (usarray Z))%type) -> (region (Z*
  (usarray Z))%type) -> (region (Z* (usarray alpha10))%type) -> pointer -> Z
   -> alpha10.
Implicit Arguments model2.

Axiom Model_footprint : forall (alpha10:Type), forall (x12:Z),
  forall (x11:pointer), forall (r_rval_g0:(region (Z* (usarray
  alpha10))%type)), forall (r_ridx_g0:(region (Z* (usarray Z))%type)),
  forall (r_rback_g0:(region (Z* (usarray Z))%type)), forall (r_g3:(region
  (pointer* pointer* pointer* Z* alpha10* Z)%type)),
  forall (r_rval_g_x0:(region (Z* (usarray alpha10))%type)),
  forall (r_ridx_g_x0:(region (Z* (usarray Z))%type)),
  forall (r_rback_g_x0:(region (Z* (usarray Z))%type)),
  forall (r_g_x0:(region (pointer* pointer* pointer* Z* alpha10* Z)%type)),
  (extends r_rval_g_x0 r_rval_g0) -> ((extends r_ridx_g_x0 r_ridx_g0) ->
  ((extends r_rback_g_x0 r_rback_g0) -> ((extends r_g_x0 r_g3) ->
  ((model2 r_g_x0 r_rback_g_x0 r_ridx_g_x0 r_rval_g_x0 x11
  x12) = (model2 r_g3 r_rback_g0 r_ridx_g0 r_rval_g0 x11 x12))))).

Axiom Model_in : forall (alpha11:Type), forall (r_rval_g1:(region (Z*
  (usarray alpha11))%type)), forall (r_ridx_g1:(region (Z* (usarray
  Z))%type)), forall (r_rback_g1:(region (Z* (usarray Z))%type)),
  forall (r_g4:(region (pointer* pointer* pointer* Z* alpha11* Z)%type)),
  forall (a8:pointer), forall (i5:Z), (is_elt r_g4 r_rback_g1 r_ridx_g1
  r_rval_g1 a8 i5) -> ((model2 r_g4 r_rback_g1 r_ridx_g1 r_rval_g1 a8
  i5) = (select match (get r_rval_g1 match (get r_g4
  a8) with
  | (x, _, _, _, _, _) => x
  end) with
  | (_, x) => x
  end i5)).

Axiom Model_out : forall (alpha12:Type), forall (r_rval_g2:(region (Z*
  (usarray alpha12))%type)), forall (r_ridx_g2:(region (Z* (usarray
  Z))%type)), forall (r_rback_g2:(region (Z* (usarray Z))%type)),
  forall (r_g5:(region (pointer* pointer* pointer* Z* alpha12* Z)%type)),
  forall (a9:pointer), forall (i6:Z), (~ (is_elt r_g5 r_rback_g2 r_ridx_g2
  r_rval_g2 a9 i6)) -> ((model2 r_g5 r_rback_g2 r_ridx_g2 r_rval_g2 a9
  i6) = match (get r_g5 a9) with
  | (_, _, _, _, x, _) => x
  end).

Definition into(n:Z) (k:Z) (t:(usarray Z)): Prop := forall (i9:Z),
  (interval 0%Z i9 n) -> (interval 0%Z (select t i9) k).

Definition injective(n0:Z) (t0:(usarray Z)): Prop := forall (i10:Z),
  forall (j0:Z), (interval 0%Z i10 n0) -> ((interval 0%Z j0 n0) ->
  (((select t0 i10) = (select t0 j0)) -> (i10 = j0))).

Definition surjective(n1:Z) (t1:(usarray Z)): Prop := forall (k0:Z),
  (interval 0%Z k0 n1) -> exists j1:Z, (interval 0%Z j1 n1) /\ ((select t1
  j1) = k0).

Theorem Array_injective_is_surjective : forall (n2:Z), forall (a11:(usarray
  Z)), ((into n2 n2 a11) /\ (injective n2 a11)) -> (surjective n2 a11).
(* YOU MAY EDIT THE PROOF BELOW *)
Require injection_is_surjective.
intros z a (Hinto,Hinj).
intros k Hinterval_k.
pose (f i := select a i).
generalize 
  (injection_is_surjective.Zinjective_implies_surjective 
     z f Hinto Hinj k Hinterval_k).
intros (x,(h1,h2)).
exists x; auto.

Qed.
(* DO NOT EDIT BELOW *)


