(**************************************************************************)
(* Copyright (c) 2010, Romain BARDOU                                      *)
(* All rights reserved.                                                   *)
(*                                                                        *)
(* Redistribution and  use in  source and binary  forms, with  or without *)
(* modification, are permitted provided that the following conditions are *)
(* met:                                                                   *)
(*                                                                        *)
(* * Redistributions  of  source code  must  retain  the above  copyright *)
(*   notice, this list of conditions and the following disclaimer.        *)
(* * Redistributions in  binary form  must reproduce the  above copyright *)
(*   notice, this list of conditions  and the following disclaimer in the *)
(*   documentation and/or other materials provided with the distribution. *)
(* * Neither the  name of Capucine nor  the names of its contributors may *)
(*   be used  to endorse or  promote products derived  from this software *)
(*   without specific prior written permission.                           *)
(*                                                                        *)
(* THIS SOFTWARE  IS PROVIDED BY  THE COPYRIGHT HOLDERS  AND CONTRIBUTORS *)
(* "AS  IS" AND  ANY EXPRESS  OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT *)
(* LIMITED TO, THE IMPLIED  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR *)
(* A PARTICULAR PURPOSE  ARE DISCLAIMED. IN NO EVENT  SHALL THE COPYRIGHT *)
(* OWNER OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, *)
(* SPECIAL,  EXEMPLARY,  OR  CONSEQUENTIAL  DAMAGES (INCLUDING,  BUT  NOT *)
(* LIMITED TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, *)
(* DATA, OR PROFITS; OR BUSINESS  INTERRUPTION) HOWEVER CAUSED AND ON ANY *)
(* THEORY OF  LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY,  OR TORT *)
(* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING  IN ANY WAY OUT OF THE USE *)
(* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.   *)
(**************************************************************************)

type t = {
  types: (string * Ast.typ) list;
  type_variables: string list;
  regions: (string * Ast.region option) list;
  classes: (string * Ast.class_def) list;
  values: (string * Ast.value_def) list;
  variables: (string * Ast.typ) list;
}

let empty = {
  types = [];
  type_variables = [];
  regions = [];
  classes = [];
  values = [];
  variables = [];
}

let add_type env id t =
  { env with types = (id, t) :: env.types }

let add_type_var env id =
  { env with type_variables = id :: env.type_variables }

let add_region env id =
  { env with regions = (id, None) :: env.regions }

let add_sub_region env id r =
  { env with regions = (id, Some r) :: env.regions }

let add_class env id c =
  { env with classes = (id, c) :: env.classes }

let add_value env id v =
  { env with values = (id, v) :: env.values }

let add_var env id t =
  { env with variables = (id, t) :: env.variables }

let get_class env id =
  List.assoc id env.classes

let get_value env id =
  List.assoc id env.values

let get_var env id =
  List.assoc id env.variables

let get_region_parent env id =
  List.assoc id env.regions

let mem_type env id =
  List.mem_assoc id env.types

let mem_type_var env id =
  List.mem id env.type_variables

let mem_region env id =
  List.mem_assoc id env.regions

let mem_class env id =
  List.mem_assoc id env.classes
