(**************************************************************************)
(* Copyright (c) 2010, Romain BARDOU                                      *)
(* All rights reserved.                                                   *)
(*                                                                        *)
(* Redistribution and  use in  source and binary  forms, with  or without *)
(* modification, are permitted provided that the following conditions are *)
(* met:                                                                   *)
(*                                                                        *)
(* * Redistributions  of  source code  must  retain  the above  copyright *)
(*   notice, this list of conditions and the following disclaimer.        *)
(* * Redistributions in  binary form  must reproduce the  above copyright *)
(*   notice, this list of conditions  and the following disclaimer in the *)
(*   documentation and/or other materials provided with the distribution. *)
(* * Neither the  name of Capucine nor  the names of its contributors may *)
(*   be used  to endorse or  promote products derived  from this software *)
(*   without specific prior written permission.                           *)
(*                                                                        *)
(* THIS SOFTWARE  IS PROVIDED BY  THE COPYRIGHT HOLDERS  AND CONTRIBUTORS *)
(* "AS  IS" AND  ANY EXPRESS  OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT *)
(* LIMITED TO, THE IMPLIED  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR *)
(* A PARTICULAR PURPOSE  ARE DISCLAIMED. IN NO EVENT  SHALL THE COPYRIGHT *)
(* OWNER OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, *)
(* SPECIAL,  EXEMPLARY,  OR  CONSEQUENTIAL  DAMAGES (INCLUDING,  BUT  NOT *)
(* LIMITED TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, *)
(* DATA, OR PROFITS; OR BUSINESS  INTERRUPTION) HOWEVER CAUSED AND ON ANY *)
(* THEORY OF  LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY,  OR TORT *)
(* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING  IN ANY WAY OUT OF THE USE *)
(* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.   *)
(**************************************************************************)

open Lexing
open Format

type t = Lexing.position * Lexing.position

let locate_error (b, e) s =
  let buf = Buffer.create 128 in
  let fmt = formatter_of_buffer buf in
  kfprintf
    (fun _ ->
       fprintf fmt "@?";
       eprintf "File \"%s\", line %d, characters %d-%d:\n%s@."
         b.pos_fname b.pos_lnum (b.pos_cnum - b.pos_bol)
         (e.pos_cnum - b.pos_bol)
         (Buffer.contents buf);
       exit 1)
    fmt
    s

let locate_warning (b, e) s =
  let buf = Buffer.create 128 in
  let fmt = formatter_of_buffer buf in
  kfprintf
    (fun _ ->
       fprintf fmt "@?";
       eprintf "File \"%s\", line %d, characters %d-%d:\n%s@."
         b.pos_fname b.pos_lnum (b.pos_cnum - b.pos_bol)
         (e.pos_cnum - b.pos_bol)
         (Buffer.contents buf))
    fmt
    s

let dummy_location = Lexing.dummy_pos, Lexing.dummy_pos
