(**************************************************************************)
(* Copyright (c) 2010, Romain BARDOU                                      *)
(* All rights reserved.                                                   *)
(*                                                                        *)
(* Redistribution and  use in  source and binary  forms, with  or without *)
(* modification, are permitted provided that the following conditions are *)
(* met:                                                                   *)
(*                                                                        *)
(* * Redistributions  of  source code  must  retain  the above  copyright *)
(*   notice, this list of conditions and the following disclaimer.        *)
(* * Redistributions in  binary form  must reproduce the  above copyright *)
(*   notice, this list of conditions  and the following disclaimer in the *)
(*   documentation and/or other materials provided with the distribution. *)
(* * Neither the  name of Capucine nor  the names of its contributors may *)
(*   be used  to endorse or  promote products derived  from this software *)
(*   without specific prior written permission.                           *)
(*                                                                        *)
(* THIS SOFTWARE  IS PROVIDED BY  THE COPYRIGHT HOLDERS  AND CONTRIBUTORS *)
(* "AS  IS" AND  ANY EXPRESS  OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT *)
(* LIMITED TO, THE IMPLIED  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR *)
(* A PARTICULAR PURPOSE  ARE DISCLAIMED. IN NO EVENT  SHALL THE COPYRIGHT *)
(* OWNER OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, *)
(* SPECIAL,  EXEMPLARY,  OR  CONSEQUENTIAL  DAMAGES (INCLUDING,  BUT  NOT *)
(* LIMITED TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, *)
(* DATA, OR PROFITS; OR BUSINESS  INTERRUPTION) HOWEVER CAUSED AND ON ANY *)
(* THEORY OF  LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY,  OR TORT *)
(* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING  IN ANY WAY OUT OF THE USE *)
(* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.   *)
(**************************************************************************)

open Misc
open Why

let region =
  let id = Ident.create "region" in
  fun x -> logic_type ~args: [ x ] id

let pointer = logic_type (Ident.create "pointer")

let either =
  let id = Ident.create "either" in
  fun x y -> logic_type ~args: [ x; y ] id

let set, expr_set =
  let id = Ident.create "set" in
  (fun r p x -> term_app id [ r; p; x ]),
  (fun r p x -> app (app (app (var id) r) p) x)

let get, expr_get =
  let id = Ident.create "get" in
  (fun r p -> term_app id [ r; p ]),
  (fun r p -> app (app (var id) r) p)

let left, expr_left =
  let id = Ident.create "left" in
  (fun x -> term_app id [ x ]),
  (fun x -> app (var id) x)

let right, expr_right =
  let id = Ident.create "right" in
  (fun x -> term_app id [ x ]),
  (fun x -> app (var id) x)

let disjoint_union, expr_disjoint_union =
  let id = Ident.create "disjoint_union" in
  (fun x y -> term_app id [ x; y ]),
  (fun x y -> app (app (var id) x) y)

let empty, expr_empty =
  let id = Ident.create "empty" in
  term_var id,
  var id

let extends =
  let id = Ident.create "extends" in
  fun r r' ->
    a_app id [ r; r' ]

let in_region =
  let id = Ident.create "in_region" in
  fun p r ->
    a_app id [ p; r ]

type 'a context = {
  var: Ident.t -> 'a;
  deref: ?at: Ident.t -> Ident.t -> 'a;
  set: 'a -> 'a -> 'a -> 'a;
  empty: 'a;
}

let in_term: term context = {
  var = term_var;
  deref = term_deref;
  set = set;
  empty = empty;
}

let in_expr: expr context = {
  var = var;
  deref = (fun ?at -> assert (at = None); deref);
  set = expr_set;
  empty = expr_empty;
}
