(**************************************************************************)
(* Copyright (c) 2010, Romain BARDOU                                      *)
(* All rights reserved.                                                   *)
(*                                                                        *)
(* Redistribution and  use in  source and binary  forms, with  or without *)
(* modification, are permitted provided that the following conditions are *)
(* met:                                                                   *)
(*                                                                        *)
(* * Redistributions  of  source code  must  retain  the above  copyright *)
(*   notice, this list of conditions and the following disclaimer.        *)
(* * Redistributions in  binary form  must reproduce the  above copyright *)
(*   notice, this list of conditions  and the following disclaimer in the *)
(*   documentation and/or other materials provided with the distribution. *)
(* * Neither the  name of Capucine nor  the names of its contributors may *)
(*   be used  to endorse or  promote products derived  from this software *)
(*   without specific prior written permission.                           *)
(*                                                                        *)
(* THIS SOFTWARE  IS PROVIDED BY  THE COPYRIGHT HOLDERS  AND CONTRIBUTORS *)
(* "AS  IS" AND  ANY EXPRESS  OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT *)
(* LIMITED TO, THE IMPLIED  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR *)
(* A PARTICULAR PURPOSE  ARE DISCLAIMED. IN NO EVENT  SHALL THE COPYRIGHT *)
(* OWNER OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, *)
(* SPECIAL,  EXEMPLARY,  OR  CONSEQUENTIAL  DAMAGES (INCLUDING,  BUT  NOT *)
(* LIMITED TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, *)
(* DATA, OR PROFITS; OR BUSINESS  INTERRUPTION) HOWEVER CAUSED AND ON ANY *)
(* THEORY OF  LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY,  OR TORT *)
(* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING  IN ANY WAY OUT OF THE USE *)
(* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.   *)
(**************************************************************************)

open Misc
open Tast
open Icommon

(*
writes computation environment:
  function name -> its written root region names
(don't forget to substitute these region names at call site)

writes computation will return more writes than needed as local references
will be returned too; scope them out after

THIS SHOULD BE COHERENT WITH ACTUAL INTERPRETATION
*)

let call_writes env wenv acc f rl =
  let fd = find_fun_decl env f in
  let fw =
    try
      Env.find wenv f
    with Not_found ->
      log "effects.ml, call_writes: cannot find %a in writes environment"
        Ident.pp f;
      assert false (* impossible without mutual recursion *)
  in
  List.fold_left2
    (fun acc (root, _) (formal, _) ->
      if ISet.mem formal fw then
        ISet.add root acc
      else
        acc)
    acc
    rl
    fd.f_region_parameters

let rec writes env wenv acc s =
  match s with
    | IWeakenSingle _
    | IWeakenEmpty _
    | IUnpack _
    | IPack _
    | ILetRegion _
    | ILet _
    | IAssert _
    | IAssume _
    | ILabel _
    | IUseInvariant _
      -> acc

    | IUnfocus (_, _, _, (r, _), _)
    | INew (_, _, (r, _), _)
    | IFocus (_, _, _, (r, _))
    | IAffect (_, _, (r, _), _)
    | IAdopt (_, _, _, (r, _), _)
      -> ISet.add r acc

    | IIf (_, s1, s2)
      -> sequence_writes env wenv (sequence_writes env wenv acc s1) s2

    | ICall (_, f, rpl, _, _)
      -> call_writes env wenv acc f (List.map snd rpl)

and sequence_writes env wenv acc s =
  List.fold_left (writes env wenv) acc s

let fun_writes env wenv f =
  (* TODO: fixpoint? *)
  let wenv = Env.add wenv f.f_name ISet.empty in

  let w = sequence_writes env wenv ISet.empty f.f_body in
  let scope =
    List.fold_left
      (fun acc (id, _) -> ISet.add id acc)
      ISet.empty
      f.f_region_parameters
  in
  ISet.inter w scope
