(** Lang parser entry points *)

open Lang_ast

(** {2 Entry Points} *)

val region_of_channel: in_channel -> region
val region_of_file: string -> region
val region_of_function: (string -> int -> int) -> region
val region_of_string: string -> region

val type_expr_of_channel: in_channel -> type_expr
val type_expr_of_file: string -> type_expr
val type_expr_of_function: (string -> int -> int) -> type_expr
val type_expr_of_string: string -> type_expr

val expr_of_channel: in_channel -> expr
val expr_of_file: string -> expr
val expr_of_function: (string -> int -> int) -> expr
val expr_of_string: string -> expr

val const_of_channel: in_channel -> const
val const_of_file: string -> const
val const_of_function: (string -> int -> int) -> const
val const_of_string: string -> const

val instruction_of_channel: in_channel -> instruction
val instruction_of_file: string -> instruction
val instruction_of_function: (string -> int -> int) -> instruction
val instruction_of_string: string -> instruction

val logic_expr_of_channel: in_channel -> logic_expr
val logic_expr_of_file: string -> logic_expr
val logic_expr_of_function: (string -> int -> int) -> logic_expr
val logic_expr_of_string: string -> logic_expr

val logic_region_of_channel: in_channel -> logic_region
val logic_region_of_file: string -> logic_region
val logic_region_of_function: (string -> int -> int) -> logic_region
val logic_region_of_string: string -> logic_region

val permission_of_channel: in_channel -> permission
val permission_of_file: string -> permission
val permission_of_function: (string -> int -> int) -> permission
val permission_of_string: string -> permission

val class_expr_of_channel: in_channel -> class_expr
val class_expr_of_file: string -> class_expr
val class_expr_of_function: (string -> int -> int) -> class_expr
val class_expr_of_string: string -> class_expr

val decl_of_channel: in_channel -> decl
val decl_of_file: string -> decl
val decl_of_function: (string -> int -> int) -> decl
val decl_of_string: string -> decl

val file_of_channel: in_channel -> file
val file_of_file: string -> file
val file_of_function: (string -> int -> int) -> file
val file_of_string: string -> file

val ident_of_channel: in_channel -> ident
val ident_of_file: string -> ident
val ident_of_function: (string -> int -> int) -> ident
val ident_of_string: string -> ident

(** {2 Location Tools} *)

val print_location: Format.formatter -> location -> unit
val dummy_location: location

(** {2 Printers} *)

(** Those functions print Abstract Syntax Trees (ASTs) in the OCaml syntax,
    not in the syntax of your language. This is handy for debugging, to check
    that your AST is the AST you expect.
    Please note that location nodes are ignored, and if you use
    polymorphic variants, the backquote is omitted.

    Put [true] in the boolean argument if you need parentheses around the
    expression if the expression is not simple. *)

val print_region: bool -> Format.formatter -> region -> unit

val print_type_expr: bool -> Format.formatter -> type_expr -> unit

val print_expr: bool -> Format.formatter -> expr -> unit

val print_const: bool -> Format.formatter -> const -> unit

val print_instruction: bool -> Format.formatter -> instruction -> unit

val print_logic_expr: bool -> Format.formatter -> logic_expr -> unit

val print_logic_region: bool -> Format.formatter -> logic_region -> unit

val print_permission: bool -> Format.formatter -> permission -> unit

val print_class_expr: bool -> Format.formatter -> class_expr -> unit

val print_decl: bool -> Format.formatter -> decl -> unit

val print_file: bool -> Format.formatter -> file -> unit

val print_ident: bool -> Format.formatter -> ident -> unit
