%{
  open Parsing
  open Lang_ast

  let loc () =
    symbol_start_pos (), symbol_end_pos ()

  let node x = {
    loc = loc ();
    node = x;
  }
%}

%token AMPERSAND_AMPERSAND
%token AROBASE
%token COLON
%token COMMA
%token DIV
%token DOT
%token EOF
%token EQUAL
%token EQUAL_EQUAL_GT
%token GT
%token GT_EQUAL
%token HAT_c
%token HAT_e
%token HAT_g
%token HAT_o
%token <string> IDENT
%token <int> INT
%token KWadopt
%token KWas
%token KWassert
%token KWassume
%token KWaxiom
%token KWbool
%token KWclass
%token KWconsumes
%token KWelse
%token KWempty
%token KWexists
%token KWfalse
%token KWfocus
%token KWforall
%token KWfun
%token KWget
%token KWgroup
%token KWif
%token KWin
%token KWint
%token KWinvariant
%token KWlabel
%token KWlemma
%token KWlet
%token KWlogic
%token KWnew
%token KWnot
%token KWpack
%token KWpost
%token KWpre
%token KWproduces
%token KWregion
%token KWreturn
%token KWsingle
%token KWthen
%token KWtrue
%token KWtype
%token KWunfocus
%token KWunit
%token KWunpack
%token KWuse
%token KWweaken
%token LBRACE
%token LBRACKET
%token LPAR
%token LT
%token LT_EQUAL
%token LT_EQUAL_GT
%token LT_GT
%token LT_MINUS
%token MINUS
%token MINUS_GT
%token PLUS
%token QUESTION
%token QUOTE
%token RBRACE
%token RBRACKET
%token RPAR
%token SEMI
%token SHARP
%token STAR
%token VERT_VERT

%left DOT
%right EQUAL_EQUAL_GT LT_EQUAL_GT
%left AMPERSAND_AMPERSAND VERT_VERT
%nonassoc KWnot
%left EQUAL LT_GT
%left GT LT GT_EQUAL LT_EQUAL
%left PLUS MINUS
%left STAR DIV
%nonassoc KWin
%nonassoc AROBASE

%type <Lang_ast.region> region
%start region

%type <Lang_ast.type_expr> type_expr
%start type_expr

%type <Lang_ast.expr> expr
%start expr

%type <Lang_ast.const> const
%start const

%type <Lang_ast.instruction> instruction
%start instruction

%type <Lang_ast.logic_expr> logic_expr
%start logic_expr

%type <Lang_ast.logic_region> logic_region
%start logic_region

%type <Lang_ast.permission> permission
%start permission

%type <Lang_ast.class_expr> class_expr
%start class_expr

%type <Lang_ast.decl> decl
%start decl

%type <Lang_ast.file> file
%start file

%type <Lang_ast.ident> ident
%start ident
%%

ident: | IDENT { (node (Ident $1)) };

file: | parsini_139 EOF { $1 };

parsini_139: | decl parsini_139 { ($1 :: $2) } | { [] };

decl:
  | KWfun
    IDENT
    parsini_103
    LPAR
    parsini_104
    RPAR
    COLON
    type_expr
    parsini_107
    parsini_109
    parsini_110
    parsini_111
    LBRACE
    sequence
    parsini_112
    RBRACE
    { (node (DFun ($2, $3, $5, $8, $9, $10, $11, $12, $14, $15))) }
  | KWclass
    IDENT
    parsini_115
    parsini_118
    LBRACE
    parsini_120
    parsini_121
    parsini_122
    RBRACE
    { (node (DClass ($2, $3, $4, $6, $7, $8))) }
  | KWtype IDENT parsini_126 { (node (DType ($2, $3))) }
  | KWlogic
    IDENT
    parsini_130
    parsini_133
    parsini_134
    parsini_135
    { (node (DLogic ($2, $3, $4, $5, $6))) }
  | KWaxiom IDENT COLON logic_expr { (node (DAxiom ($2, $4))) }
  | KWlemma IDENT COLON logic_expr { (node (DLemma ($2, $4))) };

parsini_135: | EQUAL logic_expr { (Some $2) } | { None };

parsini_134: | COLON type_expr { (Some $2) } | { None };

parsini_133: | LPAR parsini_131 RPAR { (Some $2) } | { None };

parsini_131:
  | IDENT COLON type_expr parsini_132 { (($1, $3) :: $4) }
  | { [] };

parsini_132:
  | COMMA IDENT COLON type_expr parsini_132 { (($2, $4) :: $5) }
  | { [] };

parsini_130: | LBRACKET parsini_128 RBRACKET { (Some $2) } | { None };

parsini_128:
  | IDENT COLON class_expr parsini_129 { (($1, $3) :: $4) }
  | { [] };

parsini_129:
  | COMMA IDENT COLON class_expr parsini_129 { (($2, $4) :: $5) }
  | { [] };

parsini_126: | LPAR parsini_124 RPAR { (Some $2) } | { None };

parsini_124: | QUOTE IDENT parsini_125 { ($2 :: $3) } | { [] };

parsini_125: | COMMA QUOTE IDENT parsini_125 { ($3 :: $4) } | { [] };

parsini_122: | KWinvariant logic_expr { (Some $2) } | { None };

parsini_121:
  | IDENT COLON type_expr SEMI parsini_121 { (($1, $3) :: $5) }
  | { [] };

parsini_120:
  | parsini_119
    IDENT
    COLON
    class_expr
    SEMI
    parsini_120
    { (($1, $2, $4) :: $6) }
  | { [] };

parsini_119: | KWsingle { (node Single) } | KWgroup { (node Group) };

parsini_118: | LPAR parsini_116 RPAR { (Some $2) } | { None };

parsini_116: | QUOTE IDENT parsini_117 { ($2 :: $3) } | { [] };

parsini_117: | COMMA QUOTE IDENT parsini_117 { ($3 :: $4) } | { [] };

parsini_115: | LBRACKET parsini_113 RBRACKET { (Some $2) } | { None };

parsini_113:
  | IDENT COLON class_expr parsini_114 { (($1, $3) :: $4) }
  | { [] };

parsini_114:
  | COMMA IDENT COLON class_expr parsini_114 { (($2, $4) :: $5) }
  | { [] };

parsini_112: | KWreturn expr { (Some $2) } | { None };

parsini_111: | KWpost logic_expr { (Some $2) } | { None };

parsini_110: | KWpre logic_expr { (Some $2) } | { None };

parsini_109: | KWproduces parsini_108 { (Some $2) } | { None };

parsini_108: | permission parsini_108 { ($1 :: $2) } | { [] };

parsini_107: | KWconsumes parsini_106 { (Some $2) } | { None };

parsini_106: | permission parsini_106 { ($1 :: $2) } | { [] };

parsini_104:
  | IDENT COLON type_expr parsini_105 { (($1, $3) :: $4) }
  | { [] };

parsini_105:
  | COMMA IDENT COLON type_expr parsini_105 { (($2, $4) :: $5) }
  | { [] };

parsini_103: | LBRACKET parsini_101 RBRACKET { (Some $2) } | { None };

parsini_101:
  | IDENT COLON class_expr parsini_102 { (($1, $3) :: $4) }
  | { [] };

parsini_102:
  | COMMA IDENT COLON class_expr parsini_102 { (($2, $4) :: $5) }
  | { [] };

class_expr: | IDENT parsini_97 parsini_100 { ($1, $2, $3) };

parsini_100: | LPAR parsini_98 RPAR { (Some $2) } | { None };

parsini_98: | type_expr parsini_99 { ($1 :: $2) } | { [] };

parsini_99: | COMMA type_expr parsini_99 { ($2 :: $3) } | { [] };

parsini_97: | LBRACKET parsini_95 RBRACKET { (Some $2) } | { None };

parsini_95: | region parsini_96 { ($1 :: $2) } | { [] };

parsini_96: | COMMA region parsini_96 { ($2 :: $3) } | { [] };

permission:
  | region HAT_e { (node (PEmpty $1)) }
  | region HAT_o { (node (POpen $1)) }
  | region HAT_c { (node (PClosed $1)) }
  | region HAT_g { (node (PGroup $1)) }
  | region MINUS_GT region { (node (PFocus ($1, $3))) };

logic_region:
  | ident { (node (LRoot $1)) }
  | KWget
    LPAR
    logic_region
    COMMA
    logic_expr
    COMMA
    IDENT
    RPAR
    { (node (LOwn ($3, $5, $7))) };

logic_expr:
  | const { (node (LConst $1)) }
  | logic_expr PLUS logic_expr { (node (LBinOp ($1, (node LAdd), $3))) }
  | logic_expr MINUS logic_expr { (node (LBinOp ($1, (node LSub), $3))) }
  | logic_expr DIV logic_expr { (node (LBinOp ($1, (node LDiv), $3))) }
  | logic_expr STAR logic_expr { (node (LBinOp ($1, (node LMul), $3))) }
  | logic_expr EQUAL logic_expr { (node (LBinOp ($1, (node LEq), $3))) }
  | logic_expr LT_GT logic_expr { (node (LBinOp ($1, (node LNeq), $3))) }
  | logic_expr GT logic_expr { (node (LBinOp ($1, (node LGt), $3))) }
  | logic_expr LT logic_expr { (node (LBinOp ($1, (node LLt), $3))) }
  | logic_expr GT_EQUAL logic_expr { (node (LBinOp ($1, (node LGe), $3))) }
  | logic_expr LT_EQUAL logic_expr { (node (LBinOp ($1, (node LLe), $3))) }
  | logic_expr
    EQUAL_EQUAL_GT
    logic_expr
    { (node (LBinOp ($1, (node LImpl), $3))) }
  | logic_expr
    LT_EQUAL_GT
    logic_expr
    { (node (LBinOp ($1, (node LIff), $3))) }
  | logic_expr
    AMPERSAND_AMPERSAND
    logic_expr
    { (node (LBinOp ($1, (node LAnd), $3))) }
  | logic_expr VERT_VERT logic_expr { (node (LBinOp ($1, (node LOr), $3))) }
  | KWnot logic_expr { (node (LNot $2)) }
  | ident { (node (LVar $1)) }
  | KWforall
    IDENT
    COLON
    type_expr
    DOT
    logic_expr
    { (node (LForall ($2, $4, $6))) }
  | KWexists
    IDENT
    COLON
    type_expr
    DOT
    logic_expr
    { (node (LExists ($2, $4, $6))) }
  | KWforall
    KWregion
    IDENT
    COLON
    class_expr
    DOT
    logic_expr
    { (node (LForallRegion ($3, $5, $7))) }
  | KWexists
    KWregion
    IDENT
    COLON
    class_expr
    DOT
    logic_expr
    { (node (LExistsRegion ($3, $5, $7))) }
  | KWget
    LPAR
    logic_region
    COMMA
    logic_expr
    COMMA
    IDENT
    RPAR
    { (node (LGet ($3, $5, $7))) }
  | logic_expr KWin logic_region { (node (LIn ($1, $3))) }
  | logic_expr AROBASE ident { (node (LAt ($1, $3))) }
  | logic_expr AROBASE KWpre { (node (LAtPre $1)) }
  | ident parsini_85 LPAR parsini_86 RPAR { (node (LApp ($1, $2, $4))) }
  | LPAR logic_expr RPAR { $2 };

parsini_86: | logic_expr parsini_87 { ($1 :: $2) } | { [] };

parsini_87: | COMMA logic_expr parsini_87 { ($2 :: $3) } | { [] };

parsini_85: | LBRACKET parsini_83 RBRACKET { (Some $2) } | { None };

parsini_83: | logic_region parsini_84 { ($1 :: $2) } | { [] };

parsini_84: | COMMA logic_region parsini_84 { ($2 :: $3) } | { [] };

sequence: | parsini_58 { $1 };

parsini_58: | instruction SEMI parsini_58 { ($1 :: $3) } | { [] };

instruction:
  | KWlet IDENT EQUAL expr { (node (ILet ($2, $4))) }
  | KWif
    expr
    KWthen
    LBRACE
    sequence
    RBRACE
    KWelse
    LBRACE
    sequence
    RBRACE
    { (node (IIf ($2, $5, $9))) }
  | KWlet
    IDENT
    EQUAL
    ident
    parsini_39
    LPAR
    parsini_40
    RPAR
    { (node (ICall ($2, $4, $5, $7))) }
  | KWlet KWregion IDENT COLON class_expr { (node (ILetRegion ($3, $5))) }
  | KWlet
    IDENT
    EQUAL
    KWnew
    LBRACKET
    region
    RBRACKET
    { (node (INew ($2, $6))) }
  | KWfocus ident KWas region { (node (IFocus ($2, $4))) }
  | ident DOT ident LT_MINUS expr { (node (IAffect ($1, $3, $5))) }
  | KWadopt region KWas region { (node (IAdopt ($2, $4))) }
  | KWunfocus region KWas region { (node (IUnfocus ($2, $4))) }
  | KWpack ident { (node (IPack $2)) }
  | KWunpack ident { (node (IUnpack $2)) }
  | KWweaken KWsingle region { (node (IWeakenSingle $3)) }
  | KWweaken KWempty region { (node (IWeakenEmpty $3)) }
  | KWassert logic_expr { (node (IAssert $2)) }
  | KWlabel IDENT { (node (ILabel $2)) }
  | KWuse KWinvariant ident { (node (IUseInvariant $3)) }
  | KWuse logic_expr { (node (IUse $2)) }
  | KWassume logic_expr { (node (IAssume $2)) };

parsini_40: | expr parsini_41 { ($1 :: $2) } | { [] };

parsini_41: | COMMA expr parsini_41 { ($2 :: $3) } | { [] };

parsini_39: | LBRACKET parsini_37 RBRACKET { (Some $2) } | { None };

parsini_37: | region parsini_38 { ($1 :: $2) } | { [] };

parsini_38: | COMMA region parsini_38 { ($2 :: $3) } | { [] };

const:
  | INT { (node (CInt $1)) }
  | KWtrue { (node CTrue) }
  | KWfalse { (node CFalse) }
  | LPAR RPAR { (node CUnit) };

expr:
  | const { (node (EConst $1)) }
  | expr PLUS expr { (node (EBinOp ($1, (node Add), $3))) }
  | expr MINUS expr { (node (EBinOp ($1, (node Sub), $3))) }
  | expr DIV expr { (node (EBinOp ($1, (node Div), $3))) }
  | expr STAR expr { (node (EBinOp ($1, (node Mul), $3))) }
  | expr EQUAL expr { (node (EBinOp ($1, (node Eq), $3))) }
  | expr LT_GT expr { (node (EBinOp ($1, (node Neq), $3))) }
  | expr GT expr { (node (EBinOp ($1, (node Gt), $3))) }
  | expr LT expr { (node (EBinOp ($1, (node Lt), $3))) }
  | expr GT_EQUAL expr { (node (EBinOp ($1, (node Ge), $3))) }
  | expr LT_EQUAL expr { (node (EBinOp ($1, (node Le), $3))) }
  | expr AMPERSAND_AMPERSAND expr { (node (EBinOp ($1, (node And), $3))) }
  | expr VERT_VERT expr { (node (EBinOp ($1, (node Or), $3))) }
  | ident { (node (EVar $1)) }
  | ident DOT ident { (node (ESelect ($1, $3))) }
  | SHARP
    ident
    parsini_29
    LPAR
    parsini_30
    RPAR
    { (node (EApp ($2, $3, $5))) };

parsini_30: | expr parsini_31 { ($1 :: $2) } | { [] };

parsini_31: | COMMA expr parsini_31 { ($2 :: $3) } | { [] };

parsini_29: | LBRACKET parsini_27 RBRACKET { (Some $2) } | { None };

parsini_27: | region parsini_28 { ($1 :: $2) } | { [] };

parsini_28: | COMMA region parsini_28 { ($2 :: $3) } | { [] };

type_expr:
  | KWint { (node TInt) }
  | KWbool { (node TBool) }
  | KWunit { (node TUnit) }
  | LBRACKET region RBRACKET { (node (TPointer $2)) }
  | LBRACKET QUESTION RBRACKET { (node TLogicPointer) }
  | QUOTE ident { (node (TPolyVar $2)) }
  | ident parsini_8 parsini_11 { (node (TLogic ($1, $2, $3))) };

parsini_11: | LPAR parsini_9 RPAR { (Some $2) } | { None };

parsini_9: | type_expr parsini_10 { ($1 :: $2) } | { [] };

parsini_10: | COMMA type_expr parsini_10 { ($2 :: $3) } | { [] };

parsini_8: | LBRACKET parsini_6 RBRACKET { (Some $2) } | { None };

parsini_6: | region parsini_7 { ($1 :: $2) } | { [] };

parsini_7: | COMMA region parsini_7 { ($2 :: $3) } | { [] };

region:
  | ident { (node (RRoot $1)) }
  | ident DOT ident { (node (ROwn ($1, $3))) };
