(**************************************************************************)
(* Copyright (c) 2010, Romain BARDOU                                      *)
(* All rights reserved.                                                   *)
(*                                                                        *)
(* Redistribution and  use in  source and binary  forms, with  or without *)
(* modification, are permitted provided that the following conditions are *)
(* met:                                                                   *)
(*                                                                        *)
(* * Redistributions  of  source code  must  retain  the above  copyright *)
(*   notice, this list of conditions and the following disclaimer.        *)
(* * Redistributions in  binary form  must reproduce the  above copyright *)
(*   notice, this list of conditions  and the following disclaimer in the *)
(*   documentation and/or other materials provided with the distribution. *)
(* * Neither the  name of Capucine nor  the names of its contributors may *)
(*   be used  to endorse or  promote products derived  from this software *)
(*   without specific prior written permission.                           *)
(*                                                                        *)
(* THIS SOFTWARE  IS PROVIDED BY  THE COPYRIGHT HOLDERS  AND CONTRIBUTORS *)
(* "AS  IS" AND  ANY EXPRESS  OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT *)
(* LIMITED TO, THE IMPLIED  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR *)
(* A PARTICULAR PURPOSE  ARE DISCLAIMED. IN NO EVENT  SHALL THE COPYRIGHT *)
(* OWNER OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, *)
(* SPECIAL,  EXEMPLARY,  OR  CONSEQUENTIAL  DAMAGES (INCLUDING,  BUT  NOT *)
(* LIMITED TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, *)
(* DATA, OR PROFITS; OR BUSINESS  INTERRUPTION) HOWEVER CAUSED AND ON ANY *)
(* THEORY OF  LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY,  OR TORT *)
(* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING  IN ANY WAY OUT OF THE USE *)
(* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.   *)
(**************************************************************************)

open Misc

let handle_file file =
  log "----- PARSING -----@.";
  let past = Lang.file_of_file file in
  Lang.print_file false Format.std_formatter past;
  log "@.----- TYPING AND INFERENCE -----@.";
  let time = Unix.gettimeofday () in
  let env, tast = Infer.file past in
  let delay = Unix.gettimeofday () -. time in
  log "@.Time spent on inference: %F@." delay;
  Pp.pp_inferred Format.std_formatter tast;
  log "@.----- WHY INTERPRETATION -----@.";
  let file = Interp.file env tast in
  match !Options.output_file with
    | None ->
        Why.to_channel stdout file
    | Some f ->
        Why.to_file f file

let handle_error f x =
  try
    f x
  with
    | Lang_ast.Parse_error (loc, msg) ->
        loge "%aParse error: %s@." Lang.print_location loc msg;
        exit 1
    | Types.Type_error (loc, msg) ->
        loge "%a%s@." Lang.print_location loc msg;
        exit 1
    | Assert_failure (file, line, char) ->
        loge "File \"%s\", line %d, characters %d-%d:@.Assert failure.@."
          file line char (char+1);
        exit 2
    | Match_failure (file, line, char) ->
        loge "File \"%s\", line %d, characters %d-%d:@.Match failure.@."
          file line char (char+1);
        exit 2
(*    | exn ->
        loge "Internal error, see error message below or above.@.";
        raise exn*)

let () =
  Options.init ();
  match !Options.file with
    | "" -> Options.usage ()
    | file -> handle_error handle_file file
