(* This file was originally generated by why.
   It can be modified; only the generated parts will be overwritten. *)
Require Export Why.
Require Export capucine_why.

(*Why logic*) Definition bool_and : bool -> bool -> bool.
Admitted.

(*Why logic*) Definition bool_or : bool -> bool -> bool.
Admitted.

(*Why logic*) Definition bool_xor : bool -> bool -> bool.
Admitted.

(*Why logic*) Definition bool_not : bool -> bool.
Admitted.

(*Why axiom*) Lemma bool_and_def :
  (forall (a:bool),
   (forall (b:bool), ((bool_and a b) = true <-> a = true /\ b = true))).
Admitted.

(*Why axiom*) Lemma bool_or_def :
  (forall (a:bool),
   (forall (b:bool), ((bool_or a b) = true <-> a = true \/ b = true))).
Admitted.

(*Why axiom*) Lemma bool_xor_def :
  (forall (a:bool), (forall (b:bool), ((bool_xor a b) = true <-> ~(a = b)))).
Admitted.

(*Why axiom*) Lemma bool_not_def :
  (forall (a:bool), ((bool_not a) = true <-> a = false)).
Admitted.

(*Why logic*) Definition ite : forall (A1:Set), bool -> A1 -> A1 -> A1.
Admitted.
Implicit Arguments ite.

(*Why axiom*) Lemma ite_true :
  forall (A1:Set),
  (forall (x:A1), (forall (y:A1), (if_then_else true x y) = x)).
Admitted.

(*Why axiom*) Lemma ite_false :
  forall (A1:Set),
  (forall (x:A1), (forall (y:A1), (if_then_else false x y) = y)).
Admitted.

(*Why logic*) Definition set_value : Z -> Z -> Z.
Admitted.

(*Why logic*) Definition value : Z -> Z.
Admitted.

(*Why axiom*) Lemma set_value_def :
  (forall (x:Z), (forall (y:Z), (set_value x y) = y)).
Admitted.

(*Why axiom*) Lemma value_def : (forall (x:Z), (value x) = x).
Admitted.

(*Why predicate*) Definition Long_inv  (value:Z) := True.

(*Why logic*) Definition set_right :
  (couple (couple (region Z) (region Z)) (couple pointer pointer))
  -> pointer -> (couple (couple (region Z) (region Z)) (couple pointer pointer)).
Admitted.

(*Why logic*) Definition set_left :
  (couple (couple (region Z) (region Z)) (couple pointer pointer))
  -> pointer -> (couple (couple (region Z) (region Z)) (couple pointer pointer)).
Admitted.

(*Why logic*) Definition set_r2 :
  (couple (couple (region Z) (region Z)) (couple pointer pointer))
  -> (region Z) -> (couple (couple (region Z) (region Z)) (couple pointer pointer)).
Admitted.

(*Why logic*) Definition set_r1 :
  (couple (couple (region Z) (region Z)) (couple pointer pointer))
  -> (region Z) -> (couple (couple (region Z) (region Z)) (couple pointer pointer)).
Admitted.

(*Why logic*) Definition right :
  (couple (couple (region Z) (region Z)) (couple pointer pointer)) -> pointer.
Admitted.

(*Why logic*) Definition left :
  (couple (couple (region Z) (region Z)) (couple pointer pointer)) -> pointer.
Admitted.

(*Why logic*) Definition r2 :
  (couple (couple (region Z) (region Z)) (couple pointer pointer)) -> (region Z).
Admitted.

(*Why logic*) Definition r1 :
  (couple (couple (region Z) (region Z)) (couple pointer pointer)) -> (region Z).
Admitted.

(*Why axiom*) Lemma set_right_def :
  (forall (x:(couple (couple (region Z) (region Z)) (couple pointer pointer))),
   (forall (y:pointer),
    (set_right x y) =
    (pair (pair (fst (fst x)) (snd (fst x))) (pair (fst (snd x)) y)))).
Admitted.

(*Why axiom*) Lemma set_left_def :
  (forall (x:(couple (couple (region Z) (region Z)) (couple pointer pointer))),
   (forall (y:pointer),
    (set_left x y) =
    (pair (pair (fst (fst x)) (snd (fst x))) (pair y (snd (snd x)))))).
Admitted.

(*Why axiom*) Lemma set_r2_def :
  (forall (x:(couple (couple (region Z) (region Z)) (couple pointer pointer))),
   (forall (y:(region Z)),
    (set_r2 x y) =
    (pair (pair (fst (fst x)) y) (pair (fst (snd x)) (snd (snd x)))))).
Admitted.

(*Why axiom*) Lemma set_r1_def :
  (forall (x:(couple (couple (region Z) (region Z)) (couple pointer pointer))),
   (forall (y:(region Z)),
    (set_r1 x y) =
    (pair (pair y (snd (fst x))) (pair (fst (snd x)) (snd (snd x)))))).
Admitted.

(*Why axiom*) Lemma right_def :
  (forall (x:(couple (couple (region Z) (region Z)) (couple pointer pointer))),
   (right x) = (snd (snd x))).
Admitted.

(*Why axiom*) Lemma left_def :
  (forall (x:(couple (couple (region Z) (region Z)) (couple pointer pointer))),
   (left x) = (fst (snd x))).
Admitted.

(*Why axiom*) Lemma r2_def :
  (forall (x:(couple (couple (region Z) (region Z)) (couple pointer pointer))),
   (r2 x) = (snd (fst x))).
Admitted.

(*Why axiom*) Lemma r1_def :
  (forall (x:(couple (couple (region Z) (region Z)) (couple pointer pointer))),
   (r1 x) = (fst (fst x))).
Admitted.

(*Why predicate*) Definition Pair_inv  (r1:(region Z)) (r2:(region Z)) (left:pointer) (right:pointer)
  := (value (get r1 left)) < (value (get r2 right)).

(* Why obligation from file "misc.why", line 135, characters 15-157: *)
(*Why goal*) Lemma incr_pair_po_3 : 
  forall (p: pointer),
  forall (R: (region (couple (couple (region Z) (region Z)) (couple pointer pointer)))),
  forall (HW_1: (Pair_inv
                 (r1 (get R p)) (r2 (get R p)) (left (get R p)) (right
                                                                 (get R p)))),
  forall (F: (region Z)),
  forall (HW_2: F =
                (set
                 (@empty Z) (right (get R p)) (get
                                               (r2 (get R p)) (right
                                                               (get R p))))),
  forall (F0: (region Z)),
  forall (HW_3: F0 =
                (set
                 F (right (get R p)) (set_value
                                      (get F (right (get R p))) ((value
                                                                  (get
                                                                   F (
                                                                   right
                                                                   (get R p)))) +
                                                                1)))),
  forall (R0: (region (couple (couple (region Z) (region Z)) (couple pointer pointer)))),
  forall (HW_4: R0 =
                (set
                 R p (set_r1
                      (get R p) (set
                                 (r1 (get R p)) (left (get R p)) (set_value
                                                                  (get
                                                                   (r1
                                                                    (
                                                                    get R p)) (
                                                                   left
                                                                   (get R p))) 
                                                                  ((value
                                                                    (
                                                                    get
                                                                    (
                                                                    r1
                                                                    (
                                                                    get R p)) (
                                                                    left
                                                                    (
                                                                    get R p)))) +
                                                                  1)))))),
  forall (HW_5: (Long_inv (value (get (r1 (get R0 p)) (left (get R p)))))),
  forall (HW_6: (Long_inv (value (get F0 (right (get R p)))))),
  forall (R1: (region (couple (couple (region Z) (region Z)) (couple pointer pointer)))),
  forall (HW_7: R1 =
                (set
                 R0 p (set_r2
                       (get R0 p) (set
                                   (r2 (get R0 p)) (right (get R p)) (
                                   get F0 (right (get R p))))))),
  (Pair_inv
   (r1 (get R1 p)) (r2 (get R1 p)) (left (get R1 p)) (right (get R1 p))).
Proof.
intros.
clear HW_5 HW_6.
unfold Pair_inv in *.
repeat
  (subst; first [rewrite fst_pair in * | rewrite snd_pair in * | rewrite get_set_eq in *
  | rewrite r1_def in * |
    rewrite r2_def in * | rewrite left_def in * | rewrite right_def in *
  | rewrite set_r1_def in *
   | rewrite set_r2_def in * | rewrite set_left_def in * | rewrite set_right_def in *
  | rewrite value_def in * | rewrite set_value_def in * ]).
omega.
Qed.