(**************************************************************************)
(* Copyright (c) 2010, Romain BARDOU                                      *)
(* All rights reserved.                                                   *)
(*                                                                        *)
(* Redistribution and  use in  source and binary  forms, with  or without *)
(* modification, are permitted provided that the following conditions are *)
(* met:                                                                   *)
(*                                                                        *)
(* * Redistributions  of  source code  must  retain  the above  copyright *)
(*   notice, this list of conditions and the following disclaimer.        *)
(* * Redistributions in  binary form  must reproduce the  above copyright *)
(*   notice, this list of conditions  and the following disclaimer in the *)
(*   documentation and/or other materials provided with the distribution. *)
(* * Neither the  name of Capucine nor  the names of its contributors may *)
(*   be used  to endorse or  promote products derived  from this software *)
(*   without specific prior written permission.                           *)
(*                                                                        *)
(* THIS SOFTWARE  IS PROVIDED BY  THE COPYRIGHT HOLDERS  AND CONTRIBUTORS *)
(* "AS  IS" AND  ANY EXPRESS  OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT *)
(* LIMITED TO, THE IMPLIED  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR *)
(* A PARTICULAR PURPOSE  ARE DISCLAIMED. IN NO EVENT  SHALL THE COPYRIGHT *)
(* OWNER OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, *)
(* SPECIAL,  EXEMPLARY,  OR  CONSEQUENTIAL  DAMAGES (INCLUDING,  BUT  NOT *)
(* LIMITED TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, *)
(* DATA, OR PROFITS; OR BUSINESS  INTERRUPTION) HOWEVER CAUSED AND ON ANY *)
(* THEORY OF  LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY,  OR TORT *)
(* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING  IN ANY WAY OUT OF THE USE *)
(* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.   *)
(**************************************************************************)

(* TODO:
   avoir deux formes de get dans la logique :
   - le get actuel, pour les régions quantifiées dans la logique ;
   - le get de la forme x.f, où x doit venir du programme.
   Ainsi le premier cas se gère comme avant et le second cas permet
   d'avoir un path et donc d'utiliser le chapeau et en plus permet de
   simplifier l'écriture des pre/post et assertions. *)

(** Capucine memory model. *)

open Misc
open Tast

(*
type model =
  | Border of Ident.t (* border of the hat: flattened part name *)
  | Flatten of flattening

and flattening = {
  fields: Ident.t IMap.t; (* field name -> flattened part name *)
  owns: hat; (* owned region name -> model *)
}

and hat = model IMap.t (* root region name -> model *)
*)

type hat
type label = Ident.t option

val print_hat: ?indent: int -> hat -> unit

(** {2 Compute Hat} *)

val empty_hat: hat

val hat_of_fun: env -> fun_decl -> hat

val restrict_hat: int -> hat -> hat

(** {2 Declaring} *)

val variables_of_region:
  env -> hat -> Ident.t -> (Ident.t * Why.logic_type) list

val variables_of_path:
  env -> hat -> path -> (Ident.t * Why.logic_type) list

(** {2 Reading} *)

val expr_field: hat -> path -> Why.expr -> Ident.t -> Why.expr
  (** Used to read a pointer field.

      Usage: [expr_field hat region_path pointer field] *)

val term_field: label -> hat -> why_path -> Why.term -> Ident.t -> Why.term
  (** See [expr_field].

      Only useful when there is a path, i.e. if the region comes from
      the program. *)

val expr_region: hat -> env -> path -> Why.expr
  (** Used when applying logic functions and predicates in programs.

      Usage: [expr_region hat region_path] *)

val term_region: label -> env -> hat -> why_path ->
  Why.term * (Ident.t * Why.decl * Why.decl) list
  (** Used when applying logic functions and predicates.

      Usage: [term_region label hat region_path]

      Return [term, q] where [q] may contain a list of
      [(id, declaration, axiom)]
      defining functions which reconstruct regions. *)

(** {2 Writing} *)

val assign_field: hat -> path -> Why.expr -> Ident.t -> Why.expr ->
  Why.expr
  (** Used to assign a pointer field.

      Usage: [assign_field hat region_path pointer field value] *)

val copy_pointer: hat -> env -> path -> Ident.t -> path -> Why.expr
  (** Used for adoption, focus and unfocus.

      Usage: [copy_pointer hat from_region_path pointer to_region_path] *)

val allocate_pointer: hat -> path -> Why.expr -> Why.expr
  (** Used to allocate a new, uninitialized pointer in a region.
      The region is assumed to be empty before the allocation.

      Usage: [ allocate_pointer hat path_to_pointer_region pointer ] *)
