(**************************************************************************)
(* Copyright (c) 2010, Romain BARDOU                                      *)
(* All rights reserved.                                                   *)
(*                                                                        *)
(* Redistribution and  use in  source and binary  forms, with  or without *)
(* modification, are permitted provided that the following conditions are *)
(* met:                                                                   *)
(*                                                                        *)
(* * Redistributions  of  source code  must  retain  the above  copyright *)
(*   notice, this list of conditions and the following disclaimer.        *)
(* * Redistributions in  binary form  must reproduce the  above copyright *)
(*   notice, this list of conditions  and the following disclaimer in the *)
(*   documentation and/or other materials provided with the distribution. *)
(* * Neither the  name of Capucine nor  the names of its contributors may *)
(*   be used  to endorse or  promote products derived  from this software *)
(*   without specific prior written permission.                           *)
(*                                                                        *)
(* THIS SOFTWARE  IS PROVIDED BY  THE COPYRIGHT HOLDERS  AND CONTRIBUTORS *)
(* "AS  IS" AND  ANY EXPRESS  OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT *)
(* LIMITED TO, THE IMPLIED  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR *)
(* A PARTICULAR PURPOSE  ARE DISCLAIMED. IN NO EVENT  SHALL THE COPYRIGHT *)
(* OWNER OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, *)
(* SPECIAL,  EXEMPLARY,  OR  CONSEQUENTIAL  DAMAGES (INCLUDING,  BUT  NOT *)
(* LIMITED TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, *)
(* DATA, OR PROFITS; OR BUSINESS  INTERRUPTION) HOWEVER CAUSED AND ON ANY *)
(* THEORY OF  LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY,  OR TORT *)
(* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING  IN ANY WAY OUT OF THE USE *)
(* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.   *)
(**************************************************************************)

open Pp
open Misc
open Tast
open Types
open Icommon

let subst_of_class_expr env ce owner =
  Infer.subst_of_class_expr dloc env ce owner

let repr_of_class_expr env ((cname, rparams, tparams) as ce) owner =
  let cd = find_class_decl env cname in
  let sreg, styp = subst_of_class_expr env ce owner in
  let svar = IMap.empty in
  let singles =
    List.map
      (fun (id, ce) -> id, Infer.subst_class_expr dloc sreg styp svar ce)
      cd.c_singles
  in
  let groups =
    List.map
      (fun (id, ce) -> id, Infer.subst_class_expr dloc sreg styp svar ce)
      cd.c_groups
  in
  let fields =
    List.map
      (fun (id, t) -> id, Infer.subst_type dloc sreg styp svar t)
      cd.c_fields
  in
  singles, groups, fields

let rec typ env t =
  match UType.find t with
    | TBase TInt -> Why.int
    | TBase TBool -> Why.bool
    | TBase TUnit -> Why.unit
    | TPointer _
    | TLogicPointer -> Whylib.pointer
    | TVar -> error "Typinterp.typ %a: type variable not unified" pp_type t
    | TPoly id -> Why.type_variable id
    | TLogic (n, r, a) ->
        let r = List.map (region_type env) r in
        let a = List.map (typ env) a in
        let args = r @ a in
        Why.logic_type ~args n

and region_type env r =
  let ce = Infer.class_expr_of_region dloc env r in
  class_tuple_type env ce

and class_tuple_type env ce =
  let owner = Ident.create "dummy_owner" in
  (* owner won't play a role in the type representation *)
  let singles, groups, fields = repr_of_class_expr env ce owner in
  let owns =
    List.map
      (fun (_, own_ce) -> Whylib.region (class_tuple_type env own_ce))
      (singles @ groups)
  in
  let fields =
    List.map
      (fun (_, fty) -> typ env fty)
      fields
  in
  Why.tuple (owns @ fields)
